/******************************************************************************
 ** $Id: Starter.java 591 2014-08-02 12:29:04Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.event.ActionEvent;

import javax.swing.AbstractButton;

/** Startet das Turnier als gedachter Button (wird von JaFuffy-Objekt abgehrt). */
@SuppressWarnings("serial")
class Starter extends AbstractButton {

    /** Speichert zu startendes Turnier */
    private Turnier turnier;

    /**
     * Setzt das zu startende Turnier als das Starter-Modell, und lsst es loslaufen.
     * 
     * @param turnier
     *            Zu startendes Turnier. Ein Null-Wert wird ignoriert.
     */
    void los(Turnier turnier) {
        this.turnier = turnier;
        if (turnier != null) {
            ActionEvent event = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "Start");
            fireActionPerformed(event);
        }
    }

    /** @return Turnier, welches mit dem Starter begonnen wird */
    Turnier turnier() {
        return turnier;
    }
}
