/******************************************************************************
 ** $Id: Auswahl.java 591 2014-08-02 12:29:04Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.Locale;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

/**
 * Auswahl der Zelle, in die das Wrfelresultat gesetzt wird. Setzt auf Wunsch in die Tabelle
 * (nach 1mal bzw. 2mal Klick).
 */
@SuppressWarnings("serial")
abstract class Auswahl extends DefaultCellEditor {

    static Constructor<? extends Auswahl> auswahlkonstruktor(Class<? extends Auswahl> klasse) {
        try {
            return klasse.getConstructor(Turnier.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /** Akustisches Signal fr besonderes Wrfelergebnis. */
    static final Geraeusch HURRA = new Geraeusch("Hurra.wav");
    static final NumberFormat NF;
    static {
        NF = NumberFormat.getInstance(Locale.GERMAN);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(2);
    }

    /** Turnier. */
    Turnier turnier;
    /** Auswertung. */
    Auswertung auswertung;
    /** Wie oft angeklickt? */
    int clicks;
    /** Aktuell angewhlter Eintrag des aktiven Spielers. */
    Tabzeile eintrag;
    /** Setzen. */
    private JButton setzen;
    /** Tabelle zum Neuzeichnen. */
    Tabelle tabelle;

    /**
     * Konstruktor.
     * 
     * @param turnier
     */
    Auswahl(Turnier turnier) {
        super(new JCheckBox());
        this.turnier = turnier;
        this.auswertung = turnier.auswertung();
        setClickCountToStart(1);
        setzen = new JButton("setzen");
        setzen.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        setzen.setFocusPainted(false);
        setzen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                geklickt();
            }
        });
    }

    /** Button klicken (beachtet Einfachklick oder nicht). */
    public void doClick() {
        setzen.doClick();
        if (!Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
            setzen.doClick();
        }
    }

    /**
     * Aktiven Eintrag auswhlen
     * 
     * @param eintrag
     */
    void eintrag(Tabzeile eintrag) {
        this.eintrag = eintrag;
        clicks = 0;
        editorComponent = setzen;
    }

    /**
     * @return Zelleneditor (JButton)
     */
    @Override
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int col) {
        eintrag(Tabzeile.eintrag(row));
        tabelle = (Tabelle) table;
        aktualisieren();
        return editorComponent;
    }

    /** Manahmen, falls Eintrag angeklickt wurde. */
    abstract void geklickt();

    /** Durchzufhrende Aktionen nach dem Wrfeln, z.B. Tipp aktualisieren. */
    void gewuerfelt() {
        aktualisieren();
    }

    /** Tipp aktualisieren. */
    private void aktualisieren() {
        String text;
        if (eintrag != null) {
            fireEditingCanceled();
            text = "1 Klick = " + auswertung.wert(eintrag) + " Punkte";
            if (auswertung.tipps()) {
                text =
                        "<html><p>" + text + "</p>" + "<p>Endstandwertung "
                                + NF.format(auswertung.wichtung(eintrag)) + "</p></html>";
            }
            editorComponent.setToolTipText(text);
        }
    }

}
