/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Aenderungen;
import jafuffy.CEWuerfel;
import java.util.Random;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;

class Wuerfel
extends JToggleButton.ToggleButtonModel
implements Comparable<Wuerfel> {
    private static final long serialVersionUID = 6889772262239748227L;
    private static final Random ZUFALL = new Random();
    static final int AUGEN = 6;
    private final Aenderungen<CEWuerfel> aenderungen;
    private int augen;
    private boolean vorgeschlagen;

    Wuerfel(int augen) {
        this.augen = augen;
        this.aenderungen = new Aenderungen();
    }

    public void installiereChangeListener(ChangeListener changeListener) {
        this.aenderungen.addChangeListener(changeListener);
    }

    @Override
    public int compareTo(Wuerfel wuerfel) {
        if (this.augen() < wuerfel.augen()) {
            return -1;
        }
        if (this.augen() > wuerfel.augen()) {
            return 1;
        }
        return 0;
    }

    public void entferneChangeListener(ChangeListener changeListener) {
        this.aenderungen.removeChangeListener(changeListener);
    }

    @Override
    public void setSelected(boolean selektiert) {
        boolean feuern = this.isSelected() ^ selektiert;
        super.setSelected(selektiert);
        if (feuern) {
            this.aenderungen.fireStateChanged(selektiert ? CEWuerfel.ANWAHL : CEWuerfel.ABWAHL);
        }
    }

    int augen() {
        return this.augen;
    }

    void setzeVorschlag(boolean vorschlagen) {
        this.vorgeschlagen = vorschlagen;
    }

    boolean vorgeschlagen() {
        return this.vorgeschlagen;
    }

    void wirf() {
        this.vorgeschlagen = false;
        this.augen = ZUFALL.nextInt(6) + 1;
        this.aenderungen.fireStateChanged(CEWuerfel.WURF);
        this.setSelected(false);
    }
}

