/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Eigenschaften;
import jafuffy.Fenster;
import jafuffy.Pfad;
import jafuffy.Signal;
import jafuffy.Statistik;
import jafuffy.Turnier;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Ende
extends WindowAdapter
implements ChangeListener {
    private final Statistik statistik;
    private final Fenster fenster;
    private Turnier turnier;

    Ende(Statistik statistik, Fenster fenster) {
        this.statistik = statistik;
        this.fenster = fenster;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    this.turnier = (Turnier)ce.getSource();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.turnier = null;
                }
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent we) {
        if (Eigenschaften.GLOBAL.neustart() || JOptionPane.showConfirmDialog(this.fenster, "JaFuffy beenden?", "JaFuffy (Frage)", 0) == 0) {
            this.sichereTurnierEigenschaften();
            this.sichereStatistik();
            this.beendeApplikation();
        }
    }

    private void beendeApplikation() {
        if (this.turnier != null) {
            this.turnier.beende();
        }
        this.fenster.setDefaultCloseOperation(3);
    }

    private void sichereStatistik() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(Pfad.datei("Statistik.obj")));
            out.writeObject(this.statistik);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(this.fenster, "Statistik konnte nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }

    private void sichereTurnierEigenschaften() {
        try {
            Eigenschaften.GLOBAL.speichere(this.fenster.getX(), this.fenster.getY(), this.fenster.getWidth(), this.fenster.getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(this.fenster, "JaFuffy-Einstellungen konnten nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }
}

