/******************************************************************************
 ** $Id: Messwert.java 3293 2024-05-14 20:59:54Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class Messwert extends JLabel {
    private static final long serialVersionUID = -4676526140805682921L;

    private static final String N_A = "n. a.";

    Messwert(final String platzhalter) {
        super(platzhalter);
        setFont(new Font("Monospaced", getFont().getStyle(), getFont().getSize()));
        setPreferredSize(new Dimension(SwingUtilities.computeStringWidth(getFontMetrics(getFont()), platzhalter),
                getPreferredSize().height));
    }

    void leere() {
        setText(N_A);
    }
}