/******************************************************************************
 ** $Id: Instrument.java 3279 2024-05-09 20:21:20Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Instrument extends JPanel {
    private static final long serialVersionUID = 379049791542892260L;
    private static int ABSTAND = 2;

    Instrument(final String titel) {
        setBorder(BorderFactory.createTitledBorder(titel));
        setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
    }

    void erstelle(final String groessentitel, final Messwert darstellung) {
        erstelle(groessentitel, darstellung, null);
    }

    void erstelle(final String groessentitel, final Messwert darstellung, final String hinweis) {
        final JLabel groesse = new JLabel(groessentitel);
        groesse.setAlignmentY(Component.TOP_ALIGNMENT);
        groesse.setToolTipText(hinweis);
        groesse.setFont(new Font("Monospaced", getFont().getStyle(), getFont().getSize()));
        final JPanel messung = new JPanel(new FlowLayout(FlowLayout.LEADING, 0, 0));
        messung.setAlignmentX(Component.LEFT_ALIGNMENT);
        messung.setLayout(new BoxLayout(messung, BoxLayout.LINE_AXIS));
        messung.setBorder(BorderFactory.createEmptyBorder(ABSTAND, 2 * ABSTAND, ABSTAND, 2 * ABSTAND));
        messung.add(groesse);
        darstellung.setAlignmentY(Component.TOP_ALIGNMENT);
        messung.add(darstellung);
        add(messung);
    }

}