/******************************************************************************
 ** $Id: Info.java 3595 2024-09-07 18:39:14Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class Info extends JDialog {
    private static final long serialVersionUID = -3181805210540596535L;

    private static final int ABSTAND = 8;
    private static final Icon ICON = new ImageIcon(Info.class.getResource("Button.png"));
    private static final String HOMEPAGE = "https://3kelvin.de/ebflmaennle/";
    private static final String VERSION = Info.class.getPackage().getImplementationVersion();

    public Info(final Fenster fenster) {
        super(fenster, "Ebflmännle: Über");

        final JPanel info = new JPanel();
        info.setLayout(new BoxLayout(info, BoxLayout.PAGE_AXIS));
        info.setBorder(BorderFactory.createEmptyBorder(ABSTAND, ABSTAND, ABSTAND, ABSTAND));

        JLabel zeile;
        zeile = new JLabel("<html>" + "<i>Ebflmännle</i>" + " liegt in der Version vom " + VERSION + " vor.<html>");
        zeile.setHorizontalAlignment(SwingConstants.CENTER);
        zeile.setAlignmentX(Component.CENTER_ALIGNMENT);
        info.add(zeile);
        info.add(Box.createVerticalStrut(ABSTAND / 2));
        zeile = new JLabel(
                "<html>" + "<i>Ebflmännle</i> unterliegt als freie Software der GNU General Public License Version 3."
                        + "<html>");
        zeile.setHorizontalAlignment(SwingConstants.CENTER);
        zeile.setAlignmentX(Component.CENTER_ALIGNMENT);
        info.add(zeile);
        info.add(Box.createVerticalStrut(ABSTAND / 2));
        zeile = new JLabel("<html>Eine kommerzielle Verwertung bedarf jedoch der Zustimmung des Autors.<html>");
        zeile.setHorizontalAlignment(SwingConstants.CENTER);
        zeile.setAlignmentX(Component.CENTER_ALIGNMENT);
        info.add(zeile);

        final JButton ok = new JButton(ICON);
        ok.addActionListener(e -> setVisible(false));
        ok.setAlignmentX(Component.CENTER_ALIGNMENT);

        info.add(Box.createVerticalStrut(ABSTAND));
        info.add(ok);
        info.add(Box.createVerticalStrut(ABSTAND));

        zeile = new JLabel("<html>" + "<p>" + "&copy; "
                + (VERSION != null ? VERSION.substring(VERSION.lastIndexOf(' ')) : " heute") + " Wolfgang Hauck "
                + "</p>" + "<html>");
        zeile.setHorizontalAlignment(SwingConstants.CENTER);
        zeile.setAlignmentX(Component.CENTER_ALIGNMENT);
        info.add(zeile);

        zeile = new JLabel(HOMEPAGE);
        zeile.setHorizontalAlignment(SwingConstants.CENTER);
        zeile.setAlignmentX(Component.CENTER_ALIGNMENT);
        zeile.setForeground(Color.BLUE);
        zeile.addMouseListener(new MouseListener() {
            @Override
            public void mouseClicked(final MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(HOMEPAGE));
                } catch (final Exception ex) {
                    System.out.println(ex);
                }
            }

            @Override
            public void mouseEntered(final MouseEvent e) {
                setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            @Override
            public void mouseExited(final MouseEvent e) {
                setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            }

            @Override
            public void mousePressed(final MouseEvent e) {
                return;
            }

            @Override
            public void mouseReleased(final MouseEvent e) {
                return;
            }
        });
        info.add(zeile);

        getRootPane().setDefaultButton(ok);
        setTitle("Ebflmännle (Über)");
        setContentPane(info);
        setModal(true);
        pack();
        setLocationRelativeTo(fenster);
    }

}
