/******************************************************************************
 ** $Id: Foto.java 3595 2024-09-07 18:39:14Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Programms Ebflmännle.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class Foto extends JFileChooser {
    private static final long serialVersionUID = -6013891875359116081L;

    private final Fenster fenster;

    public Foto(final Fenster fenster) {
        this.fenster = fenster;
        setDialogTitle("Ebflmännle: Bildexport als Bilddatei im PNG-Format");
        final FileFilter filter = new FileFilter() {
            @Override
            public String getDescription() {
                return "Bilddatei im PNG-Format";
            }

            @Override
            public boolean accept(final File datei) {
                return datei.isDirectory() || datei.getName().toLowerCase().endsWith(".png");
            }
        };
        addChoosableFileFilter(filter);
        setFileFilter(filter);
    }

    public void vollfuehre(final BufferedImage bild) {
        if (showSaveDialog(fenster) == JFileChooser.APPROVE_OPTION) {
            try {
                File datei;
                if (getSelectedFile().getName().toLowerCase().endsWith(".png")) {
                    datei = getSelectedFile();
                } else {
                    datei = new File(getSelectedFile().getAbsolutePath() + ".png");
                }
                ImageIO.write(bild, "png", datei);
            } catch (final IOException exception) {
                exception.printStackTrace();
            }
        }

    }
}
