/******************************************************************************
 ** $Id: Formatierer.java 3409 2024-07-18 14:03:11Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.text.DecimalFormat;

class Formatierer extends DecimalFormat {

    private static final long serialVersionUID = 5776164572571169988L;

    static final String PLATZHALTER_ESIGN = "+";
    static final String PLATZHALTER_KOORDINATE_POS = "+0.000000000000000E00";
    static final String PLATZHALTER_KOORDINATE_NEG = "-";
    static final String PLATZHALTER_KOORDINATE = PLATZHALTER_KOORDINATE_POS + ";" + PLATZHALTER_KOORDINATE_NEG;
    // Maximalanzahl der Iterationen beschränkt auf 2^24 = 16777216 = 1.6777216E7
    static final String PLATZHALTER_LIMIT = "+0.000000E0";
    static final String PLATZHALTER_LIMIT_STUFE = "00";
    static final String PLATZHALTER_LIMIT_EXP = "0.0E00";
    // Maximalanzahl der Iterationen beschränkt auf 2^24, daher ist maximale feststellbare Periode auf 2^23 = 8388608
    static final String PLATZHALTER_PERIODE = "######0;P";
    static final Formatierer FORMAT_KOORDINATE = new Formatierer(Formatierer.PLATZHALTER_KOORDINATE);
    static final Formatierer FORMAT_LIMIT = new Formatierer(PLATZHALTER_LIMIT);
    static final Formatierer FORMAT_LIMIT_STUFE = new Formatierer(PLATZHALTER_LIMIT_STUFE);
    static final Formatierer FORMAT_LIMIT_EXP = new Formatierer(PLATZHALTER_LIMIT_EXP);
    static final Formatierer FORMAT_PERIODE = new Formatierer(PLATZHALTER_PERIODE);

    public Formatierer(final String format) {
        super(format);
    }

    String formatiere(final double zahl) {
        var ausgabe = super.format(zahl);
        if (!ausgabe.contains("E-")) {
            ausgabe = ausgabe.replace("E", "E+");
        }
        return ausgabe;
    }

    String formatiere(final float zahl) {
        var ausgabe = super.format(zahl);
        if (!ausgabe.contains("E-")) {
            ausgabe = ausgabe.replace("E", "E+");
        }
        return ausgabe;
    }
}