/******************************************************************************
 ** $Id: Fenster.java 3554 2024-08-17 21:49:05Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

public class Fenster extends JFrame implements PropertyChangeListener {

    private static final long serialVersionUID = 5320202717147882693L;

    private static final String TRENNER = "/";
    private static final String VERAENDERT = "*";
    private static final String RECHNEND = "...";
    private static final String BESCHAEFTIGT = TRENNER + "Berechnung läuft" + RECHNEND;
    private static final String STOPP = "!";
    private static final String ABGEBROCHEN = TRENNER + "Berechnung abgebrochen" + STOPP;
    private static final int MINIMALBREITE = 450;
    private static final int MINIMALHOEHE = 400;
    private static final Image ICON16 = Toolkit.getDefaultToolkit()
            .getImage(Fenster.class.getResource("Transparent16.png"));
    private static final Image ICON32 = Toolkit.getDefaultToolkit()
            .getImage(Fenster.class.getResource("Transparent32.png"));
    private static final Image ICON48 = Toolkit.getDefaultToolkit()
            .getImage(Fenster.class.getResource("Transparent48.png"));
    private static final ArrayList<Image> ICONS = new ArrayList<>();
    static {
        ICONS.add(ICON16);
        ICONS.add(ICON32);
        ICONS.add(ICON48);
    }

    public Fenster() {
        setMinimumSize(new Dimension(MINIMALBREITE, MINIMALHOEHE));
        setResizable(true);
        setTitle("Ebflmännle - ");
        setIconImages(ICONS);
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    }

    @Override
    public void paint(final Graphics g) {
        final var istgroesse = getSize();
        final var maximalgroesse = getMaximumSize();
        final var aenderung = istgroesse.width > maximalgroesse.width || istgroesse.height > maximalgroesse.height;
        istgroesse.width = Math.min(maximalgroesse.width, istgroesse.width);
        istgroesse.height = Math.min(maximalgroesse.height, istgroesse.height);
        if (aenderung) {
            setSize(istgroesse);
        }
        super.paint(g);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        final var name = event.getPropertyName();
        final var titel = getTitle();
        if ("Berechnung".equals(name)) {
            if ((boolean) event.getNewValue()) {
                if (titel.endsWith(VERAENDERT)) {
                    setTitle(titel + BESCHAEFTIGT);
                } else if (titel.endsWith(STOPP)) {
                    setTitle(titel.split(TRENNER)[0] + BESCHAEFTIGT);
                } else {
                    setTitle(titel + VERAENDERT + BESCHAEFTIGT);
                }
            } else if (!titel.endsWith(STOPP)) {
                setTitle(titel.split(TRENNER)[0]);
            }
        } else if ("Stopp".equals(name)) {
            setTitle(titel.split(TRENNER)[0] + ABGEBROCHEN);
        }
    }

}
