/******************************************************************************
 ** $Id: Definitionsexport.java 3595 2024-09-07 18:39:14Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Programms Ebflmännle.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class Definitionsexport extends JFileChooser {

    private static final long serialVersionUID = -4771843063747193181L;
    private final Fenster fenster;
    private final Definitionsoperation definitionsoperation;

    public Definitionsexport(final Fenster fenster, final Definitionsoperation definitionsoperation) {
        this.fenster = fenster;
        this.definitionsoperation = definitionsoperation;
        setDialogTitle("Ebflmännle: Definitionsexport als Textdatei im " + Definitionsoperation.FORMAT + "-Format");
        final var filter = new FileFilter() {
            @Override
            public boolean accept(final File datei) {
                return datei.isDirectory() || datei.getName().toLowerCase().endsWith(Definitionsoperation.SUFFIX);
            }

            @Override
            public String getDescription() {
                return "Definitionsdatei im " + Definitionsoperation.FORMAT + "-Format";
            }
        };
        addChoosableFileFilter(filter);
        setFileFilter(filter);
    }

    public void vollfuehre() {
        setSelectedFile(definitionsoperation.datei());
        if (showSaveDialog(fenster) != APPROVE_OPTION) {
            return;
        }
        final File datei;
        if (getSelectedFile().getName().toLowerCase().endsWith(Definitionsoperation.SUFFIX)) {
            datei = getSelectedFile();
        } else {
            datei = new File(getSelectedFile().getAbsolutePath() + Definitionsoperation.SUFFIX);
        }
        final var name = definitionsoperation.exportiere(datei);
        fenster.setTitle("Ebflmännle - " + name);
    }

}
