/******************************************************************************
 ** $Id: Definitionseingabe.java 3595 2024-09-07 18:39:14Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ebflmaennle.berechnung.Ausschnitt;

public class Definitionseingabe extends JDialog implements PropertyChangeListener {

    private static final int ABSTAND = 10;

    private static final long serialVersionUID = -3289911878307226919L;

    static JPanel eingaberahmen(final String name, final String hilfe) {
        final var eingaberahmen = new JPanel();
        eingaberahmen.setLayout(new BoxLayout(eingaberahmen, BoxLayout.PAGE_AXIS));
        eingaberahmen.setBorder(BorderFactory.createTitledBorder(name));
        eingaberahmen.setToolTipText(hilfe);
        return eingaberahmen;
    }

    static JPanel eingabezeile(final String name, final int laenge, final JTextField feld) {
        final var label = new JLabel(name);
        label.setFont(new Font("Monospaced", label.getFont().getStyle(), label.getFont().getSize()));
        feld.setColumns(laenge);
        feld.setFont(new Font("Monospaced", feld.getFont().getStyle(), feld.getFont().getSize()));
        final var eingabezeile = new JPanel();
        eingabezeile.add(label);
        eingabezeile.add(feld);
        return eingabezeile;
    }

    final JTextField a = new JTextField();
    final JTextField b = new JTextField();
    final JTextField m = new JTextField();
    final JTextField n = new JTextField();
    final JTextField zoom = new JTextField();
    final JTextField limit = new JTextField();

    public Definitionseingabe(final Fenster fenster) {
        super(fenster, "Ebflmännle: Definitionseingabe");
        setModal(true);

        final var mittelpunkt = eingaberahmen("Mittelpunkt c = a + i*b", "Koordinaten des Mittelpunkts");
        mittelpunkt.add(eingabezeile("a = ", 20, a));
        mittelpunkt.add(eingabezeile("b = ", 20, b));

        final var faktor = eingaberahmen("Faktor/Iteration", "Vergrößerungsfaktor");
        faktor.add(eingabezeile("* : 2 ^", 5, zoom));
        faktor.add(eingabezeile("# : ", 10, limit));

        final var gitter = eingaberahmen("Gitter", "");
        gitter.add(eingabezeile("m = ", 5, m));
        gitter.add(eingabezeile("n = ", 5, n));

        final var datenfeld = new JPanel(new FlowLayout(FlowLayout.LEADING));
        datenfeld.add(mittelpunkt);
        datenfeld.add(gitter);
        datenfeld.add(faktor);
        final var ok = new JButton("OK");
        ok.setMnemonic(KeyEvent.VK_O);
        ok.addActionListener(event -> setVisible(false));
        final var abbruch = new JButton("Abbruch");
        abbruch.setMnemonic(KeyEvent.VK_A);
        abbruch.addActionListener(event -> setVisible(false));
        final var kontrollfeld = new JPanel(new GridLayout(1, 2, ABSTAND, ABSTAND));
        kontrollfeld.setBorder(BorderFactory.createEmptyBorder(ABSTAND / 2, ABSTAND / 2, ABSTAND / 2, ABSTAND / 2));
        kontrollfeld.add(ok);
        kontrollfeld.add(abbruch);

        final var hauptfeld = new JPanel(new BorderLayout(ABSTAND, ABSTAND));
        hauptfeld.setBorder(BorderFactory.createEmptyBorder(ABSTAND, ABSTAND, ABSTAND, ABSTAND));
        hauptfeld.add(datenfeld, BorderLayout.CENTER);
        hauptfeld.add(kontrollfeld, BorderLayout.PAGE_END);

        getRootPane().setDefaultButton(ok);
        setContentPane(hauptfeld);
        pack();
        setLocationRelativeTo(fenster);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        final var name = event.getPropertyName();
        if (name == "Bildgröße") {
            final var ausschnitt = (Dimension) event.getNewValue();
            m.setText(Integer.toString(ausschnitt.width));
            n.setText(Integer.toString(ausschnitt.height));
        } else if (name == "Auflösung") {
            final double zoomwert = Ausschnitt.BASISPXS / (float) event.getNewValue();
            zoom.setText(Double.toString(Math.log(zoomwert) / Math.log(2)));
        } else if (name == "Iterationslimit") {
            final var limitwert = (int) event.getNewValue();
            limit.setText(Integer.toString(limitwert));
        } else if (name == "Sichtfenster") {
            final var fenster = (Rectangle2D.Double) event.getNewValue();
            a.setText(Double.toString(fenster.getX() + fenster.getWidth() / 2));
            b.setText(Double.toString(fenster.getY() + fenster.getHeight() / 2));
        }
    }

}
