/******************************************************************************
 ** $Id: Aktion.java 3571 2024-08-31 20:55:59Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.oberflaeche;

import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class Aktion extends AbstractAction {
    private static final long serialVersionUID = -1520973426656705615L;

    private Aktion(final String name, final int taste, final int modifizierer, final boolean selektiert,
            final String hilfe, final String kommando) {
        super(name);
        putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke(taste, modifizierer));
        putValue(SELECTED_KEY, selektiert);
        putValue(ACTION_COMMAND_KEY, kommando);
        putValue(SHORT_DESCRIPTION, hilfe);
    }

    private Aktion(final String name, final int taste, final String hilfe, final String kommando) {
        this(name, taste, 0, false, hilfe, kommando);
    }

    public Aktion(final String name, final int taste, final int modifizierer, final String kommando) {
        this(name, taste, modifizierer, false, null, kommando);
    }

    public Aktion(final String name, final int taste, final boolean selektiert, final String hilfe) {
        this(name, taste, 0, selektiert, hilfe, name);
    }

    public Aktion(final String name, final int taste, final boolean selektiert) {
        this(name, taste, selektiert, null);
    }

    public Aktion(final String name, final int taste) {
        this(name, taste, false);
    }

    public Aktion(final String name, final int taste, final String hilfe) {
        this(name, taste, hilfe, name);
    }

    @Override
    public void setEnabled(final boolean aktiviert) {
        super.setEnabled(aktiviert);
        if (!aktiviert) {
            setSelected(false);
        }
    }

    public boolean isSelected() {
        return (boolean) getValue(SELECTED_KEY);
    }

    public void setSelected(final boolean selected) {
        putValue(SELECTED_KEY, selected);
    }

}
