/******************************************************************************
 ** $Id: Retro.java 3393 2024-07-14 12:39:08Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.farbe;

class Retro extends Faerber {

    private final float verschiebung;

    Retro(final float farbperiode, final float verschiebung, final int versatz, final boolean prinzip,
            final boolean abstandkonturen, final boolean multiplikatorkonturen, final boolean zentrumhervorhebung) {
        super(farbperiode, verschiebung, versatz, prinzip, abstandkonturen, multiplikatorkonturen,
                zentrumhervorhebung, Faerber.ZENTRUMFARBE);
        this.verschiebung = Math.round(FARBPERIODE * verschiebung) + 0.5f;
    }

    @Override
    protected float fluchtfarbe(final float nu) {
        return nu + verschiebung;
    }

    @Override
    protected int potentialfarbe(final float fluchtfarbe, final float rhoq) {
        if (rhoq < RHOQ) {
            return RANDFARBE;
        }
        return HELLKONTRASTFARBEN[(int) (fluchtfarbe) % HELLKONTRASTFARBEN.length];
    }

}
