/******************************************************************************
 ** $Id$
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.farbe;

import ebflmaennle.berechnung.Option;
import ebflmaennle.farbe.Modell.Modus;

public final class Parameter {
    private static final float ANFANGSFARBPERIODE = (float) Math.pow(10, -0.3);
    private static final float ANFANGSKORREKTUR = 1f;
    private static final float ANFANGSPEKTRUM = 1f;
    private static final float ANFANGVERSCHIEBUNG = 0.5f;
    private static final float ANFANGFREQUENZFAKTOR = 5f;

    public float farbperiode = ANFANGSFARBPERIODE;
    public float korrektur = ANFANGSKORREKTUR;
    public float spektrum = ANFANGSPEKTRUM;
    public float verschiebung = ANFANGVERSCHIEBUNG;
    public int versatz;
    public float frequenzfaktor = ANFANGFREQUENZFAKTOR;
    public Modus modus = Modus.HSB;
    public boolean prinzipdarstellung = Option.PRINZIPIEN;
    public boolean abstandkonturen;
    public boolean multiplikatorkonturen;
    public boolean zentrumhervorhebung;
}