/******************************************************************************
 ** $Id: HSBNeon.java 3393 2024-07-14 12:39:08Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.farbe;

/** Gesamter Kreis im Buntwert, volle Sättigung und Helligkeit. */
class HSBNeon extends Faerber {

    protected final boolean gespreizt;
    protected final float relativfarbperiode;
    protected final float verschiebung;

    HSBNeon(final float farbperiode, final float korrektur, final float frequenzfaktor, final float verschiebung,
            final int versatz, final boolean prinzip, final boolean abstandkonturen,
            final boolean multiplikatorkonturen, final boolean zentrumhervorhebung, final int zentrumfarbe) {
        super(frequenzfaktor, verschiebung, versatz, prinzip, abstandkonturen, multiplikatorkonturen,
                zentrumhervorhebung, zentrumfarbe);
        this.gespreizt = farbperiode < 1;
        this.relativfarbperiode = farbperiode / FARBPERIODE;
        this.verschiebung = verschiebung;
        if (korrektur != 1) {
            nacharbeit = original -> (float) Math.pow(original, korrektur);
        }
    }

    HSBNeon(final float farbperiode, final float korrektur, final float frequenzfaktor, final float verschiebung,
            final int versatz, final boolean prinzip, final boolean abstandkonturen,
            final boolean multiplikatorkonturen, final boolean zentrumhervorhebung) {
        this(farbperiode, korrektur, frequenzfaktor, verschiebung, versatz, prinzip, abstandkonturen,
                multiplikatorkonturen, zentrumhervorhebung, ZENTRUMFARBE);
    }

    protected int rgb(final float fluchtfarbe, final float helligkeit, final float saettigung) {
        final var sektor = 6 * fluchtfarbe;
        final var basis = Math.floor(sektor);
        final var f = (float) (sektor - basis);
        final var p = helligkeit * (1 - saettigung);
        final var q = helligkeit * (1 - saettigung * f);
        final var t = helligkeit + p - q; // = helligkeit * (1 - saettigung * (1 - f))
        return switch ((int) basis) {
            case 5 -> allgemeinkodierung(helligkeit, p, q);
            case 4 -> allgemeinkodierung(t, p, helligkeit);
            case 3 -> allgemeinkodierung(p, q, helligkeit);
            case 2 -> allgemeinkodierung(p, helligkeit, t);
            case 1 -> allgemeinkodierung(q, helligkeit, p);
            default -> allgemeinkodierung(helligkeit, t, p);
        };
    }

    protected int rgb(final float fluchtfarbe) {
        final var sektor = 6 * fluchtfarbe;
        final var basis = Math.floor(sektor);
        final var f = (float) (sektor - basis);
        return switch ((int) basis) {
            case 5 -> spezialkodierung(1, 0, nacharbeit.wert(1 - f));
            case 4 -> spezialkodierung(nacharbeit.wert(f), 0, 1);
            case 3 -> spezialkodierung(0, nacharbeit.wert(1 - f), 1);
            case 2 -> spezialkodierung(0, 1, nacharbeit.wert(f));
            case 1 -> spezialkodierung(nacharbeit.wert(1 - f), 1, 0);
            default -> spezialkodierung(1, nacharbeit.wert(f), 0);
        };
    }

    @Override
    protected float fluchtfarbe(final float nu) {
        var fluchtfarbe = nu;
        if (gespreizt) {
            fluchtfarbe = relativfarbperiode * fluchtfarbe;
        } else {
            fluchtfarbe = Math.round(fluchtfarbe) / FARBPERIODE;
        }
        fluchtfarbe += verschiebung;
        fluchtfarbe -= Math.floor(fluchtfarbe);
        return fluchtfarbe;
    }

    @Override
    protected int potentialfarbe(final float fluchtfarbe, final float rhoq) {
        if (rhoq < RHOQ) {
            return rgb(fluchtfarbe, (1 - ABSTANDSDETAIL) + ABSTANDSDETAIL * r(rhoq), ABSTANDRINGSAETTIGUNG);
        }
        return rgb(fluchtfarbe);
    }

}
