/******************************************************************************
 ** $Id: Grau.java 3393 2024-07-14 12:39:08Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.farbe;

class Grau extends HSBNeon {

    private static float helligkeit(final float r, final float g, final float b) {
        return 0.3f * r + 0.6f * g + 0.1f * b + 0.1f;
    }

    Grau(final float farbperiode, final float korrektur, final float frequenzfaktor, final float verschiebung,
            final int versatz, final boolean prinzip, final boolean abstandkonturen,
            final boolean multiplikatorkonturen, final boolean zentrumhervorhebung) {
        super(farbperiode, korrektur, frequenzfaktor, verschiebung, versatz, prinzip, abstandkonturen,
                multiplikatorkonturen, zentrumhervorhebung, ZENTRUMFARBESW);
    }

    private int kodierung(final float rgb) {
        final var wert = Math.round(255 * nacharbeit.wert(rgb));
        return (wert << 16) | (wert << 8) | (wert << 0);
    }

    private int grau(final float fluchtfarbe, final float helligkeit, final float saettigung) {
        final var sektor = 6 * fluchtfarbe;
        final var basis = Math.floor(sektor);
        final var f = (float) (sektor - basis);
        final var p = helligkeit * (1 - saettigung);
        final var q = helligkeit * (1 - saettigung * f);
        final var t = helligkeit + p - q; // = helligkeit * (1 - saettigung * (1 - f))
        final var h = switch ((int) basis) {
            case 5 -> helligkeit(helligkeit, p, q);
            case 4 -> helligkeit(t, p, helligkeit);
            case 3 -> helligkeit(p, q, helligkeit);
            case 2 -> helligkeit(p, helligkeit, t);
            case 1 -> helligkeit(q, helligkeit, p);
            default -> helligkeit(helligkeit, t, p);
        };
        return kodierung(h);
    }

    private int grau(final float fluchtfarbe) {
        final var sektor = 6 * fluchtfarbe;
        final var basis = Math.floor(sektor);
        final var f = (float) (sektor - basis);
        final var helligkeit = switch ((int) basis) {
            case 5 -> helligkeit(1, 0, 1 - f);
            case 4 -> helligkeit(f, 0, 1);
            case 3 -> helligkeit(0, 1 - f, 1);
            case 2 -> helligkeit(0, 1, f);
            case 1 -> helligkeit(1 - f, 1, 0);
            default -> helligkeit(1, f, 0);
        };
        return kodierung(helligkeit);
    }

    @Override
    protected int potentialfarbe(final float fluchtfarbe, final float rhoq) {
        if (rhoq < RHOQ) {
            return grau(fluchtfarbe, (1 - ABSTANDSDETAIL) + ABSTANDSDETAIL * r(rhoq), ABSTANDSSAETTIGUNGGRAUSTUFEN);
        }
        return grau(fluchtfarbe);
    }

}
