/******************************************************************************
 ** $Id: Option.java 3594 2024-09-07 16:54:16Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

public final class Option {
    public enum Qualitaet {
        BENUTZER, AUTOMATIK, OPTIMUM
    }

    public enum Bevorzugung {
        ZEIT, STANDARD, PRAEZISION
    }

    public static final Bevorzugung BEVORZUGUNGSSTANDARD = Bevorzugung.STANDARD;
    public static final Qualitaet QUALITAETSSTANDARD = Qualitaet.AUTOMATIK;
    public static final boolean AUSSENBLOCKSCHAETZUNG = false;
    public static final boolean INNENBLOCKSCHAETZUNG = true;
    public static final boolean INNENDETEKTION = false;
    public static final boolean ABSTANDSCHAETZUNG = true;
    public static final boolean SCHRITTSCHAETZUNG = true;
    public static final boolean DISTANZSCHAETZUNG = true;
    public static final boolean ZENTRUMDETEKTION = true;
    public static final boolean ZENTRUMBERECHNUNG = false;
    public static final boolean MULTIPLIKATOREN = true;
    public static final boolean PRINZIPIEN = false;
    public static final boolean BILDFREQUENZ = true;

    public volatile boolean aussenblockschaetzung = false;
    public volatile boolean innenblockschaetzung = true;
    public volatile boolean multiplikatoren = MULTIPLIKATOREN;
    public volatile boolean zentrumdetektion = ZENTRUMDETEKTION;
    public volatile boolean zentrumberechnung = ZENTRUMBERECHNUNG;
    public volatile boolean innendetektion = INNENDETEKTION;
    public volatile boolean distanzschaetzung = DISTANZSCHAETZUNG;
    public volatile boolean abstandschaetzung = ABSTANDSCHAETZUNG;
    public volatile boolean schrittschaetzung = SCHRITTSCHAETZUNG;
    public volatile boolean koerperkopferkennung = true;
    public volatile boolean prinzipien = PRINZIPIEN;
    public volatile boolean bildfrequenz = BILDFREQUENZ;
    public volatile Qualitaet qualitaet = QUALITAETSSTANDARD;
    public volatile Bevorzugung bevorzugung = BEVORZUGUNGSSTANDARD;
}