/******************************************************************************
 ** $Id: N.java 3594 2024-09-07 16:54:16Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

import java.awt.geom.Point2D;

/** Nukleus. */
public final class N {

    private static final int DIV = 2;

    private boolean konvergent;

    final Z t;
    final Dc dc;
    final double epsilon;

    double a;
    double b;
    float lq;

    N(final Z t, final Dc dc, final double pxs) {
        this.t = t;
        this.dc = dc;
        epsilon = pxs / DIV;
    }

    void beginne(final double a, final double b) {
        konvergent = false;
        this.a = a;
        this.b = b;
    }

    void uebertrage() {
        t.parametrisiere(a, b);
        t.starte0(); // dz = 0
        t.starte1(); // t[1]
        dc.starte1(); // dc[1]
    }

    void starte() {
        t.parametrisiere(a, b);
        dc.starte2(); // -> dc[2]
        t.starte2(); // -> z[2]
    }

    /** Berechne nächsten Näherungswert mit dem Newton-Verfahren. */
    void iteriere() {
        final var tx = t.x;
        final var ty = t.y;
        final var dcx = dc.x;
        final var dcy = dc.y;
        final var dcabsq = dc.absq();
        final var da = (dcy * ty + dcx * tx) / dcabsq;
        final var db = (dcx * ty - dcy * tx) / dcabsq;
        a -= da;
        b -= db;
        konvergent = Math.abs(da) + Math.abs(db) < epsilon;
    }

    boolean divergent() {
        return !konvergent;
    }

    Point2D ort() {
        return new Point2D.Double(a, b);
    }

}
