/******************************************************************************
 ** $Id: Kontext.java 3621 2024-12-24 12:10:35Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

import ebflmaennle.berechnung.Abstandschaetzer.Groessenschaetzer;
import ebflmaennle.berechnung.Algorithmus.Schritte;

final class Kontext {

    final Z z;
    final Charakterisierung charakterisierung;
    final Linienrechner linienrechner;
    final Innendetektor innendetektor;
    final Distanzschaetzer distanzschaetzer;
    final Abstandschaetzer abstandschaetzer;
    final Wukleusfinder wukleusfinder;
    final Nukleusfinder nukleusfinder;

    boolean fuellzwang;

    Kontext(final Charakteristik[] charakteristiken, final Konfiguration konfiguration, final int m, final double delta,
            final Schritte schritte) {
        z = new Z(delta);
        innendetektor = Innendetektor.erzeuge(z, konfiguration.innendetektion || konfiguration.optimal());
        distanzschaetzer = Distanzschaetzer.erzeuge(z, konfiguration.pxs, konfiguration.aussenblockschaetzung,
                konfiguration.zentrumdetektion, konfiguration.distanzschaetzung, konfiguration.schrittschaetzung,
                konfiguration.beschleunigt);
        final var t = new Z(delta, z);
        final var dz = new Dz(t);
        final var w = new W(z, t, dz, konfiguration.epsilon);
        abstandschaetzer = Abstandschaetzer.erzeuge(w, konfiguration.pxs, konfiguration.epsilon,
                konfiguration.abstandschaetzung);
        wukleusfinder = Wukleusfinder.erzeuge(w, abstandschaetzer, konfiguration.multiplikatoren);
        final var nt = new Z();
        final var ndc = new Dc(nt);
        final var n = new N(nt, ndc, konfiguration.pxs);
        final var groessenschaetzer = new Groessenschaetzer(n);
        nukleusfinder = Nukleusfinder.erzeuge(n, groessenschaetzer);
        charakterisierung = new Charakterisierung(charakteristiken, konfiguration, m, this);
        linienrechner = new Linienrechner(charakteristiken, charakterisierung, konfiguration, m, schritte);
    }

    void finalisiere(final boolean abgebrochen) {
        fuellzwang = abgebrochen;
    }

}