/******************************************************************************
 ** $Id: Konfiguration.java 3621 2024-12-24 12:10:35Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

import java.awt.Dimension;
import java.awt.geom.Point2D;

import ebflmaennle.berechnung.Option.Bevorzugung;
import ebflmaennle.berechnung.Option.Qualitaet;

public final class Konfiguration {

    final boolean aussenblockschaetzung;
    final boolean innenblockschaetzung;
    final boolean multiplikatoren;
    final boolean zentrumdetektion;
    final boolean zentrumberechnung;
    final boolean innendetektion;
    final boolean distanzschaetzung;
    final boolean abstandschaetzung;
    final boolean schrittschaetzung;
    final boolean koerperkopferkennung;
    final boolean prinzipien;
    final boolean bildfrequenz;
    final Bevorzugung bevorzugung;
    final Qualitaet qualitaet;
    final int antialiasing;
    final int vorschau;
    final boolean fuellbar;
    final boolean beschleunigt;
    final double a0;
    final double b0;
    final double epsilon;
    final float pxs;
    final int iterationslimit;
    final int iterationslimitschranke;
    final int iterationslimitoptimum;

    Konfiguration(final Option option, final Dimension dimension, final int iterationslimit,
            final int iterationslimitschranke, final boolean fuellbar, final Point2D mitte, final double epsilon,
            final float pxs, final int antialiasing, final int vorschau, final boolean beschleunigt) {
        final var turbo = (option.bevorzugung == Bevorzugung.ZEIT || beschleunigt) && option.bildfrequenz;
        this.aussenblockschaetzung = option.aussenblockschaetzung;
        this.innenblockschaetzung = option.innenblockschaetzung || turbo;
        this.multiplikatoren = option.multiplikatoren || turbo;
        this.zentrumdetektion = option.zentrumdetektion || turbo;
        this.zentrumberechnung = option.zentrumberechnung;
        this.innendetektion = option.innendetektion && !turbo;
        this.distanzschaetzung = option.distanzschaetzung || turbo;
        this.abstandschaetzung = option.abstandschaetzung || turbo;
        this.schrittschaetzung = option.schrittschaetzung || turbo;
        this.koerperkopferkennung = option.koerperkopferkennung || turbo;
        this.prinzipien = option.prinzipien;
        this.bildfrequenz = option.bildfrequenz;
        this.bevorzugung = turbo ? Bevorzugung.ZEIT : option.bevorzugung;
        this.qualitaet = turbo ? Qualitaet.AUTOMATIK : option.qualitaet;
        this.fuellbar = fuellbar;
        this.beschleunigt = beschleunigt;
        this.a0 = mitte.getX();
        this.b0 = mitte.getY();
        this.pxs = pxs;
        this.epsilon = epsilon;
        this.antialiasing = antialiasing;
        this.vorschau = vorschau;
        this.iterationslimit = iterationslimit >> (turbo ? 1 : 0);
        this.iterationslimitschranke = iterationslimitschranke;
        this.iterationslimitoptimum = iterationslimitoptimum();
    }

    private int index(final int x) {
        return x * antialiasing / vorschau;
    }

    private int iterationslimitoptimum() {
        final int limit;
        if (optimal()) {
            var i = 0;
            while (1L << (2 * i) < (long) iterationslimit * (long) iterationslimitschranke) {
                i++;
            }
            limit = 1 << i;
        } else {
            limit = iterationslimit;
        }
        return limit / vorschau;
    }

    Dimension dimension(final Dimension dimension) {
        return new Dimension(index(dimension.width), index(dimension.height));
    }

    boolean optimal() {
        return qualitaet == Qualitaet.OPTIMUM;
    }
}