/******************************************************************************
 ** $Id: Karte.java 3633 2024-12-24 16:44:50Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.concurrent.RecursiveAction;

public final class Karte {

    private final class Leerer extends RecursiveAction {
        private static final long serialVersionUID = -8323195792953569323L;
        private final int j1;
        private final int j2;
        final Charakteristik[] charakteristiken;

        /** [j1, j2[ */
        Leerer(final Charakteristik[] charakteristiken, final int j1, final int j2) {
            this.charakteristiken = charakteristiken;
            this.j1 = j1;
            this.j2 = j2;
        }

        @Override
        protected void compute() {
            if (j2 - j1 > 1) {
                final var mitte = (j1 + j2) / 2;
                final var b1 = new Leerer(charakteristiken, j1, mitte);
                b1.fork();
                final var b2 = new Leerer(charakteristiken, mitte, j2);
                b2.compute();
                b1.join();
            } else {
                var p = j1 * m;
                for (var i = 0; i < m; i++) {
                    charakteristiken[p].leere();
                    p++;
                }
            }
        }
    }

    private int m;

    public static long speicherdatenbedarf(final int maximum) {
        final var spunktobjekt = (12 + (3 * Integer.BYTES + 2 * Short.BYTES) + 15) / 16 * 16;
        final var sfeldobjekt = 16;
        final var sfeldelement = Integer.BYTES;
        return (spunktobjekt + sfeldelement) * maximum + sfeldobjekt;
    }

    public final Charakteristik[] charakteristiken;

    public Karte(final Dimension maximum) {
        final var laenge = maximum.width * maximum.height;
        charakteristiken = new Charakteristik[laenge];
        Arrays.setAll(charakteristiken, index -> new Charakteristik());
    }

    void leere(final int m, final int n) {
        this.m = m;
        new Leerer(charakteristiken, 0, n).invoke();
    }

}
