/******************************************************************************
 ** $Id: Innendetektor.java 3631 2024-12-24 16:34:32Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle.berechnung;

abstract class Innendetektor {

    private static final class Basis extends Innendetektor {

        @Override
        boolean innen() {
            return false;
        }

        @Override
        void iteriere() {
        }

        @Override
        float mulq() {
            return Charakteristik.MULQ_OFFEN;
        }

        @Override
        void starte() {
        }
    }

    private static final class Voll extends Innendetektor {
        private final static double EPSQ = 1. / 1024;
        private final Dz dz;

        Voll(final Z z) {
            dz = new Dz(z);
        }

        @Override
        boolean innen() {
            return dz.absq < EPSQ;
        }

        @Override
        void iteriere() {
            dz.iteriere();
        }

        @Override
        float mulq() {
            return -(float) dz.absq;
        }

        @Override
        void starte() {
            dz.starte1();
        }
    }

    private static Innendetektor BASIS = new Basis();

    static Innendetektor erzeuge(final Z z, final boolean innendetektion) {
        if (innendetektion) {
            return new Voll(z);
        }
        return BASIS;
    }

    abstract boolean innen();

    abstract void iteriere();

    abstract float mulq();

    abstract void starte();

}
