/******************************************************************************
 ** $Id: Verfolgung.java 3432 2024-07-21 09:52:36Z wmh $
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ebflmaennle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import javax.swing.Action;

public class Verfolgung<T extends PropertyChangeListener> {

    private final T verfolger;

    public Verfolgung(final T verfolger) {
        this.verfolger = verfolger;
    }

    public void registriere(final Action aktivierung, final PropertyChangeSupport aenderungsverursacher) {
        aktivierung.addPropertyChangeListener(ereignis -> {
            if ("SwingSelectedKey".equals(ereignis.getPropertyName())) {
                if (ereignis.getNewValue().equals(true)) {
                    aenderungsverursacher.addPropertyChangeListener("Parameter", verfolger);
                } else {
                    aenderungsverursacher.removePropertyChangeListener("Parameter", verfolger);
                }
            }
        });
    }

}
